# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1999,2001 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package CT::SR;

#"@(#)04   1.20   src/rsct/registry/ext/CT/SR/SR.pm, srcli, rsct_rori, roris01a 3/11/01 17:54:48"

use strict;
use CT::CT;
use Carp;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS $AUTOLOAD);
use constant;
# use Devel::Peek 'Dump';  # for debugging purposes

require Exporter;
require DynaLoader;
require AutoLoader;

@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. 

@EXPORT = qw(
    SR_ACLS_PLACEHOLDER
    SR_METADATA
    SR_READ
    SR_WRITE
    SR_NONBLOCKING
    SR_BLOCKING
);

@EXPORT_OK = qw(
    SR_UNKNOWN_STORAGE              SR_PERSISTENT   
    SR_TRANSIENT                    SR_REMOTE 

    SR_UNKNOWN_MODULE               SR_CLIENT               SR_SERVER 

    SR_UNKNOWN_ENTRY                SR_TABLE                SR_DIRECTORY 
    SR_MOUNT_POINT                  SR_DIRECTORY_CONTAINER 
    SR_LOCAL_PERSISTENCE_MOUNT_POINT
    SR_TREE                         SR_REGISTRY

    SR_UNKNOWN_ENTRY_LIST           SR_PERSISTENT_TABLE     
    SR_TRANSIENT_TABLE              SR_PERSISTENT_DIRECTORY 
    SR_TRANSIENT_DIRECTORY 

    SR_UNKNOWN_QUALIFIER            SR_STANDARD     
    SR_SYSTEM                       SR_PRIMARY_KEY 
);

# use the export tags to reference each enum by name
%EXPORT_TAGS = (

sr_storage_t => [qw(
    SR_UNKNOWN_STORAGE
    SR_PERSISTENT
    SR_TRANSIENT
    SR_REMOTE
)],

sr_module_t => [qw(
    SR_UNKNOWN_MODULE
    SR_CLIENT
    SR_SERVER
)],

sr_entry_t => [qw(
    SR_UNKNOWN_ENTRY
    SR_TABLE
    SR_DIRECTORY
    SR_MOUNT_POINT
    SR_DIRECTORY_CONTAINER
    SR_LOCAL_PERSISTENCE_MOUNT_POINT
    SR_TREE
    SR_REGISTRY
)],

sr_entry_list_t => [qw(
    SR_UNKNOWN_ENTRY_LIST
    SR_PERSISTENT_TABLE
    SR_TRANSIENT_TABLE
    SR_PERSISTENT_DIRECTORY
    SR_TRANSIENT_DIRECTORY
)],

sr_qualifier_t => [qw(
    SR_UNKNOWN_QUALIFIER
    SR_STANDARD
    SR_SYSTEM
    SR_PRIMARY_KEY
)]

); # end %EXPORT_TAGS


#--------------------------------------------------------------------#
# System Registry enums defined for use in PERL.                     #
# Available Enum Definitions (constants)                             #
#--------------------------------------------------------------------#
# enums from ct_sr_types.h as of 4/11/00 sccs version 1.1

#sr_storage_t
use constant SR_UNKNOWN_STORAGE     => 0;
use constant SR_PERSISTENT          => 1;
use constant SR_TRANSIENT           => 2;
use constant SR_REMOTE              => 3;

#sr_module_t
use constant SR_UNKNOWN_MODULE      => 0;
use constant SR_CLIENT              => 1;
use constant SR_SERVER              => 2;

#sr_entry_t
use constant SR_UNKNOWN_ENTRY       => 0;
use constant SR_TABLE               => 1;
use constant SR_DIRECTORY           => 2;
use constant SR_MOUNT_POINT         => 3;
use constant SR_DIRECTORY_CONTAINER => 4;
use constant SR_LOCAL_PERSISTENCE_MOUNT_POINT => 5;
use constant SR_TREE                => 6;
use constant SR_REGISTRY            => 7;

#sr_entry_list_t
use constant SR_UNKNOWN_ENTRY_LIST  => 0;
use constant SR_PERSISTENT_TABLE    => 1;
use constant SR_TRANSIENT_TABLE     => 2;
use constant SR_PERSISTENT_DIRECTORY=> 3;
use constant SR_TRANSIENT_DIRECTORY => 4;

#sr_qualifier_t
use constant SR_UNKNOWN_QUALIFIER   => 0;
use constant SR_STANDARD            => 1;
use constant SR_SYSTEM              => 2;
use constant SR_PRIMARY_KEY         => 3;

$VERSION = '0.01';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
    if ($! =~ /Invalid/) {
        $AutoLoader::AUTOLOAD = $AUTOLOAD;
        goto &AutoLoader::AUTOLOAD;
    }
    else {
        croak "Your vendor has not defined SR macro $constname";
    }
    }
#    no strict 'refs';
#    *$AUTOLOAD = sub () { $val };
    eval "sub $AUTOLOAD { $val }";

    goto &$AUTOLOAD;

#    use strict 'refs';
}

bootstrap CT::SR $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__


=head1 NAME

CT::SR - Perl extensions for RSCT SR ct_sr.h, ct_sr_types.h 


=head1 SYNOPSIS

    use CT::SR;
    use CT::SR qw(:<export tag>);
    use CT::SR qw(<exported constant list>);      
 

=head1 DESCRIPTION

This extension is used by the Reliable Scalable Cluster Technology
(RSCT) System Registry (SR) Commands.
SR Commands are located in /usr/sbin/rsct/bin.
Some of the SR commands are:
lssr, mksrdir, rmsrdir, cpsr, mvsr, findsr, pwdsr, 
lssrtbl, lssrtbldef, mksrtbl, rmsrtbl, selectsr, joinsr,
chsrcolnm, chsrcoldv,
mksrcol, rmsrcol,
mksrrow, rmsrrow, chsrfld,
mksrfile, rmsrfile, retsrfile, repsrfile.

The Perl to C Extensions for the RSCT SR, 
CT::SR, are not being externalized at this time.
Use at your own risk!
The API to these extensions will probably change.


=head1 EXPORTED CONSTANTS

For more information regarding these exported constants see the file:
    /usr/include/rsct/ct_sr_types.h

    SR_ACLS_PLACEHOLDER
    SR_METADATA
    SR_READ
    SR_WRITE
    SR_NONBLOCKING
    SR_BLOCKING


=head1 EXPORTED TAGS

The tag names correspond to System Registry enum types.
These constants are also exported individually via EXPORT_OK.
For more information regarding these exported tags see the file:
    /usr/include/rsct/ct_sr_types.h

sr_storage_t => [qw(
    SR_UNKNOWN_STORAGE
    SR_PERSISTENT
    SR_TRANSIENT
    SR_REMOTE
)],

sr_module_t => [qw(
    SR_UNKNOWN_MODULE
    SR_CLIENT
    SR_SERVER
)],

sr_entry_t => [qw(
    SR_UNKNOWN_ENTRY
    SR_TABLE
    SR_DIRECTORY
    SR_MOUNT_POINT
    SR_DIRECTORY_CONTAINER
    SR_LOCAL_PERSISTENCE_MOUNT_POINT
    SR_TREE
    SR_REGISTRY
)],

sr_entry_list_t => [qw(
    SR_UNKNOWN_ENTRY_LIST
    SR_PERSISTENT_TABLE
    SR_TRANSIENT_TABLE
    SR_PERSISTENT_DIRECTORY
    SR_TRANSIENT_DIRECTORY
)],

sr_qualifier_t => [qw(
    SR_UNKNOWN_QUALIFIER
    SR_STANDARD
    SR_SYSTEM
    SR_PRIMARY_KEY
)]


=head1 EXPORTED FUNCTIONS

For the purpose of calling the extensions, all should be prefixed
with CT::SR::  (e.g. CT::SR::open_tree() ).
In the SR C API all functions are prefixed with sr_.

    open_tree
    close_tree
    mount_directory
    unmount_directory
    change_current_directory
    get_current_directory
    create_directory
    delete_directory
    get_directory_list
    free_directory_list
    is_in_directory
    move_entry
    copy_entry
    create_table
    delete_table
    add_columns
    delete_columns
    get_table_metadata
    free_table_metadata
    join
    close_table
    merge_table
    copy_table
    move_table
    add_row
    delete_rows
    get_field_by_key
    get_fields_by_key
    get_field_by_index
    get_fields_by_index
    set_field_by_key
    set_fields_by_key
    set_field_by_index
    set_fields_by_index
    lock_tables
    unlock_tables


=head1 AUTHOR

Licensed Materials - Property of IBM

(C) COPYRIGHT International Business Machines Corp. 1998, 2001.
All Rights Reserved.

US Government Users Restricted Rights - Use, duplication or
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.


=head1 VERSION

RSCT Version 2.2 


=head1 SEE ALSO

CT::CT, CT::SRrc

=cut
